require "lisp-symbol"

class Cons
  attr_accessor :car, :cdr
  def initialize (car, cdr)
    @car = car; @cdr = cdr
  end
  def inspect_else
    @car.inspect + if @cdr.kind_of?(Cons)
                     @cdr.inspect(nil)
                   elsif @cdr == $lisp_nil
                     ")"
                   else
                      " . " + @cdr.inspect + ")"
                   end
  end
  def inspect (topp = true)
    if topp
      if @car == find_symbol("quote","cl") and @cdr.cdr == $lisp_nil
        "'" + @cdr.car.inspect
      else
        "(" + self.inspect_else
      end
    else
      " " + self.inspect_else
    end
  end
  def length
    if @cdr.is_a?(Cons)
      1+@cdr.length
    else
      1
    end
  end
  def to_array
    if @cdr
      [@car] + @cdr.to_array
    else
      [@car]
    end
  end
  def to_s
    self.inspect
  end
end

def $lisp_nil.car
  $lisp_nil
end

def $lisp_nil.cdr
  $lisp_nil
end

def $lisp_nil.to_array
  []
end

class Object
  def car
    error "not a cons cell -- #{self.inspect}\n"
  end
  def cdr
    error "not a cons cell -- #{self.inspect}\n"
  end
  def to_array
    raise StandardError.new("Don't convert symbol to Ruby-array.")
  end
end

def list (*args)
	car = args.shift
	Cons.new(car, if args.size == 0
	                 $lisp_nil
	              else list(*args)
	              end)
end

def append_iter (list1,list2)
  if not(list1 == $lisp_nil)
    Cons.new(list1.car,append_iter(list1.cdr,list2))
  else
    list2
  end
end

def append (*args)
  car = args.shift
  append_iter(car, if args.size == 0
                      $lisp_nil
                    else append(*args)
                    end)
end

def nconc_iter (list1,list2)
  if list1.cdr == $lisp_nil
    list1.cdr = list2
  else
    nconc_iter(list1.cdr,list2)
  end
end

def nconc(*args)
  car = args.shift
  if car == $lisp_nil
    if args.size == 0
      $lisp_nil
    else
      nconc(*args)
    end
  else
    nconc_iter(car, if args.size == 0
                       $lisp_nil
                    else nconc(*args)
                    end)
    car
  end
end

def mapcar (proc,*lists)
  if lists[0] == $lisp_nil
    $lisp_nil
  else
    Cons.new(proc.call(*lists.collect{|x| x.car}),mapcar(proc,*lists.collect{|x| x.cdr}))
 end
end