;; init.lisp -- building up ANSI functions, macros, and read-macros.
;;              including some original features.(ruby-lisp-interface's read-macro)

;; some primitive read-macro
(make-dispatch-macro-character (sys::string-ref "#" 0))

(set-dispatch-macro-character (sys::string-ref "#" 0) (sys::string-ref "\\" 0)
  (function (lambda (stream char1 char2) (read-char stream))))

(set-dispatch-macro-character #\# #\'
  (function (lambda (stream char1 char2) `(function ,(read stream)))))

(set-dispatch-macro-character #\# #\.
  #'(lambda (stream char1 char2) (eval (read stream))))

(set-dispatch-macro-character #\# #\:
  #'(lambda (stream char1 char2) (error "reading uninterned symbol")))

(set-macro-character #\|
  #'(lambda (stream char) (intern (read-string #\| stream))))

;; defmacro bootstrap step1: temporary defmacro
(let ((defmacrof #'(lambda (sys::**macroargs** sys::**env**)
                     (let ((name (car (cdr sys::**macroargs**)))
                           (arglist (car (cdr (cdr sys::**macroargs**))))
                           (body (cdr (cdr (cdr sys::**macroargs**)))))
                      `(let ((f #'(lambda (sys::**macroargs** sys::**env**)
                                     (apply (function (lambda ,arglist ,@body)) (cdr sys::**macroargs**)))))
                         (sys::.set-function-name. f ',name)
                         (sys::.set-function-is-macro. f)
                         (sys::.set-symbol-function. ',name f)
                         ',name)))))
  (sys::.set-function-is-macro. defmacrof)
  (sys::.set-function-name. defmacrof 'defmacro)
  (sys::.set-symbol-function. 'defmacro defmacrof))

(defmacro sys::named-function (name arglist &body body)
  `(labels ((,name ,arglist (block ,name ,@body)))
      #',name))

(defmacro defun (name arglist &body body)
  `(let ((f (sys::named-function ,name ,arglist ,@body)))
      (sys::.set-function-name. f ',name)
      (sys::.set-symbol-function. ',name f)
      ',name))

(defun set (symbol value)
  (sys::.set-symbol-value. symbol value))

(defun intern (name &optional (package *package*))
  (sys::.intern name package))

(defun find-symbol (name &optional (package *package*))
  (sys::.find-symbol name package))

(defun unintern (symbol &optional (package *package*))
  (sys::.unintern symbol package))

(defun fdefinition (x)
  (symbol-function x))

(defun null (x)
  (not x))
(defun atom (x)
  (not (consp x)))

(defun expand-cond (clauses)
  (let ((first (car clauses)))
    (if first
      `(if ,(car first)
           (progn ,@(cdr first))
           ,(expand-cond (cdr clauses))))))

(defmacro cond (&rest clauses)
  (expand-cond clauses))

(defmacro when (pred &body body)
  `(if ,pred
      (progn ,@body)))

(defmacro unless (pred &body body)
  `(if ,pred
       nil
       (progn ,@body)))

(defun expand-and (forms)
  (let ((car (car forms))
        (name (gensym)))
    `(let ((,name ,car))
       (if ,name
         ,(if (cdr forms)
              (expand-and (cdr forms))
              name)
         nil))))
(defmacro and (&rest forms)
  (expand-and forms))

(defun expand-or (forms)
  (let ((car (car forms))
        (name (gensym)))
    `(let ((,name ,car))
       (if ,name
         ,name
         ,(if (cdr forms)
              (expand-or (cdr forms))
              nil)))))
(defmacro or (&rest forms)
  (expand-or forms))

(defun equal (x y)
  (cond ((and (consp x) (consp y))
         (and (equal (car x) (car y)) (equal (cdr x) (cdr y))))
        ((and (atom x) (atom y))
         (eq x y))
        (t nil)))
(defun listp (x)
  (or (consp x) (null x)))

(defmacro lambda (&body body)
  `(function (lambda ,@body)))

(defun funcall (fn &rest args)
  (apply fn args))

(defun sys::cars (lists)
  (if lists
    (cons (car (car lists)) (sys::cars (cdr lists)))))

(defun sys::cdrs (lists)
  (if lists
    (cons (cdr (car lists)) (sys::cdrs (cdr lists)))))

(defun mapcar (fn list &rest more-lists)
  (if list
    (cons (apply fn (cons (car list) (sys::cars more-lists)))
          (apply #'mapcar
                 (cons fn
                       (cons (cdr list)
                             (sys::cdrs more-lists)))))))

(defun cadr (x)
  (car (cdr x)))
(defun cddr (x)
  (cdr (cdr x)))
(defun caddr (x)
  (car (cddr x)))

(defun length (x)
  (if x
    (+ 1 (length (cdr x)))
    0))

(defun reverse (x)
  (if x
    (append (reverse (cdr x)) (list (car x)))
    nil))

(defun identity (x) x)
(defun member (item list &key (test #'eql) (key #'identity))
  (cond ((null list) nil)
        ((funcall test item (funcall key (car list)))
         list)
        (t (member item (cdr list) :test test :key key))))

(defun 1+ (x)
  (+ 1 x))
(defun 1- (x)
  (- x 1))

(defun subseq (sequence start &optional end)
  (if (= start 0)
      (if (not (and end sequence))
          sequence
          (if (= end 0)
              nil
              (cons (car sequence)
                    (subseq (cdr sequence) start (1- end)))))
      (subseq (cdr sequence) (1- start) (if end
                                            (1- end)))))

(defun find-if (fn list)
  (when list
    (let ((car (car list)))
      (if (funcall fn car)
        car
        (find-if fn (cdr list))))))

(defun position (item list &key (test #'eq) (start 0))
  (cond ((null list) nil)
        ((not (= start 0)) (position item (cdr list) :test test :start (1- start)))
        ((funcall test item (car list)) 0)
        (t (let ((found (position item (cdr list) :test test)))
              (if found
                  (1+ found))))))
(defun remove-if (fn list)
  (when list
    (let ((car (car list)))
      (if (funcall fn car)
        (remove-if fn (cdr list))
        (cons car (remove-if fn (cdr list)))))))
(defun complement (fn)
  #'(lambda (&rest args) (not (funcall fn args))))

(defun reduce (fn list)
  (labels ((iter (list acc)
             (if (null list)
                 acc
               (iter (cdr list) (funcall fn acc (car list))))))
    (iter (cdr list) (car list))))

(defun assoc (item alist)
  (find-if #'(lambda (x) (eql item (car x))) alist))
(defun rassoc (item alist)
  (find-if #'(lambda (x) (eql item (cdr x))) alist))

(defun getf (plist indicator &optional default)
  (if (null plist) default
    (if (eq (car plist) indicator)
        (cadr plist)
        (getf (cddr plist) indicator default))))

(defun get (symbol indicator &optional default)
  (getf (symbol-plist symbol) indicator default))

(defun gethash (key table &optional default)
  (sys::.gethash1. key table default))

(defun expand-let* (bindings body)
  (if (null bindings)
    `(progn ,@body)
    `(let (,(car bindings))
       ,(expand-let* (cdr bindings) body))))

(defmacro let* (bindings &body body)
  (expand-let* bindings body))

(defmacro case (form &rest case-clause)
  (let ((tmp (gensym)))
    `(let ((,tmp ,form))
       (cond ,@(mapcar #'(lambda (x)
                           (let ((pred (car x)))
                             (append (cond ((listp pred)
                                            (list (cons 'or (mapcar #'(lambda (y) `(eql ,tmp ',y)) pred))))
                                           ((or (eq pred t) (eq pred 'otherwise)) (list t))
                                           (t (list `(eql ,tmp ',pred))))
                                     (cdr x))))
                       case-clause)))))

(defmacro ecase (form &rest case-clause)
  `(case ,form
         ,@case-clause
         (otherwise (error "ecase error -- not found correct case"))))

(defmacro destructuring-bind (arglist form &body body)
  (let ((formsym (gensym)))
   `(let ((,formsym ,form))
      (let* ,(sys::.destruc-top arglist formsym)
         ,@body))))

;; defmacro bootstrap step2: define true defmacro by using let*
(defmacro defmacro (name arglist &body body)
  (multiple-value-bind (mllist env) (sys::.analyze-mllist arglist)
    `(let ((f #'(lambda (sys::**macroargs** sys::**env**)
                    (let ,(if env `((,env sys::**env**)))
                       (let* ,(sys::.destruc-top mllist 'sys::**macroargs**)
                          ,@body)))))
       (sys::.set-function-is-macro. f)
       (sys::.set-function-name. f ',name)
       (sys::.set-symbol-function. ',name f)
       ',name)))

(let ((table (make-hash-table)))
  (defun get-setf-expansion (place &optional env)
    (let ((op (if env
                  (macroexpand place env)
                  (macroexpand place))))
      (if (consp op)
        (let ((expander (gethash (car op) table)))
          (if expander
             (apply expander (cdr op))
             (error "undefined setf method")))
        (let ((sym (gensym)))
          (values nil nil `(,sym) `(setq ,op ,sym) op)))))
  (defmacro define-setf-expander (access-fn lambda-list &body body)
    `(progn (sys::.sethash. ',access-fn ,table #'(lambda ,lambda-list ,@body))
            ',access-fn)))

(defmacro setf (place value &environment env)
  (multiple-value-bind (dummies vals news setter getter)
    (get-setf-expansion place env)
   `(let* (,@(mapcar #'list dummies vals))
      (multiple-value-bind ,news ,value
        ,setter))))

(defmacro defsetf (form-name fn-name)
  `(define-setf-expander ,form-name (&rest place)
     (let ((subsymlist (mapcar #'(lambda (x) (gensym)) place))
           (vsym (gensym)))
       (values subsymlist place `(,vsym) `(,',fn-name ,@subsymlist ,vsym) `(,',form-name ,@subsymlist)))))

(defsetf car rplaca)
(defsetf cdr rplacd)
(defsetf gethash sys::.sethash.)
(defsetf symbol-value sys::.set-symbol-value.)
(defsetf package-nickname sys::.set-package-nickname.)
(defsetf symbol-plist sys::.set-symbol-plist.)
(defsetf aref sys::.inv-aref)

(define-setf-expander values (&rest args)
  (let ((vsyms (mapcar #'(lambda (x) (gensym)) args)))
     (values nil nil vsyms `(progn ,@(mapcar #'(lambda (x y) `(setf ,x ,y))
                                                args vsyms)
                                     (values ,@args)) `(values ,@args))))

(defmacro prog1 (&rest forms)
  (let ((value (gensym)))
    `(let ((,value ,(car forms)))
        ,@(cdr forms)
        ,value)))

(defmacro define-modify-macro (name other-args fn-name)
  `(defmacro ,name (place &rest args)
    (multiple-value-bind (dummies vals news setter getter)
      (get-setf-expansion place)
      `(let* (,@(mapcar #'list dummies vals))
         (multiple-value-bind ,news ((lambda ,',other-args (,',fn-name ,getter)) ,@args)
           ,setter)))))

(defmacro push (value place)
  (multiple-value-bind (dummies vals news setter getter)
    (get-setf-expansion place)
    `(let* (,@(mapcar #'list dummies vals))
       (multiple-value-bind ,news (cons ,value ,getter)
         ,setter))))
(defmacro pop (place)
  (multiple-value-bind (dummies vals news setter getter)
    (get-setf-expansion place)
    `(let* (,@(mapcar #'list dummies vals))
       (multiple-value-bind ,news (cdr ,getter)
         (prog1 (car ,getter)
                ,setter)))))
(define-modify-macro incf (&optional (delta 1)) (lambda (x) (+ x delta)))
(define-modify-macro decf (&optional (delta 1)) (lambda (x) (- x delta)))

(defmacro defparameter (symbol value)
  `(progn (sys::set-special ',symbol)
          (setf ,symbol ,value)
          ',symbol))

(defmacro defvar (symbol &optional value)
  `(progn (sys::set-special ',symbol)
          (if ,value
            (sys::.inv-defvar ',symbol ,value))
          ',symbol))

(defmacro defconstant (symbol value)
  `(progn (setf ,symbol ,value)
          (sys::set-constant ',symbol)
          ',symbol))

(defmacro return (&optional result)
  `(return-from nil ,result))

(defun mapcan (fn &rest lists)
  (labels ((iter (x acc)
              (if (null (car x))
                acc
                (iter (mapcar #'cdr x) (nconc acc (apply fn (mapcar #'car x)))))))
    (iter lists nil)))

;; do and tagbody features
(defmacro do (binding-clauses (end-test &rest result-body) &body body)
  (let ((tag (gensym)))
    `(block nil
       (let ,(mapcar #'(lambda (x) (list (car x) (cadr x)))
            binding-clauses)
         (tagbody
          ,tag
          (cond (,end-test (return-from nil (progn ,@result-body))))
          (tagbody ,@body)
          (psetq ,@(mapcan #'(lambda (x) `(,(car x) ,(caddr x)))
                     binding-clauses))
          (go ,tag))))))

(defmacro do* (binding-clauses (end-test &rest result-body) &body body)
  (let ((tag (gensym)))
    `(block nil
       (let* ,(mapcar #'(lambda (x) (list (car x) (cadr x)))
                binding-clauses)
         (tagbody
          ,tag
          (cond (,end-test (return-from nil (progn ,@result-body))))
          (tagbody ,@body)
          (setq ,@(mapcan #'(lambda (x) `(,(car x) ,(caddr x)))
                     binding-clauses))
          (go ,tag))))))

(defmacro dolist ((var list &optional result-form) &body body)
  (let ((sym (gensym)))
    `(do* ((,sym ,list (cdr ,sym)) (,var (car ,sym) (car ,sym)))
          ((null ,sym) ,result-form)
       ,@body)))

(defmacro dotimes ((var times &optional result-form) &body body)
  `(do ((,var 0 (1+ ,var)))
       ((>= ,var ,times) ,result-form)
     ,@body))

(defun sys::.inv-get (symbol indicator value)
  (let ((plist (symbol-plist symbol)))
    (do ((iter plist (cddr iter)))
        ((null iter) (setf (symbol-plist symbol) (cons indicator (cons value plist))) value)
      (when (eq (car iter) indicator)
         (setf (car (cdr iter)) value)
         (return value)))))

(defsetf get sys::.inv-get)

(defun every (fn seq)
  (dolist (i seq t)
    (unless (funcall fn i)
      (return nil))))

(defun some (fn seq)
  (dolist (i seq nil)
    (let ((tmp (funcall fn i)))
      (when tmp
        (return tmp)))))

(set-dispatch-macro-character #\# #\(
  #'(lambda (stream char1 char2)
      (let* ((initial-elements (read-delimited-list #\) stream))
             (alength (length initial-elements))
             (result (make-array alength)))
        (do ((elements initial-elements (cdr elements))
             (pos 0 (1+ pos)))
            ((null elements) result)
          (setf (aref result pos) (car elements))))))

;; input and output stream utilities
(defun print (x &optional stream)
  (sys::.print x stream))
(defun princ (x &optional stream)
  (sys::.princ x stream))

(defun open (filespec &key (direction :input))
  (if (eq direction :input)
    (sys::open-input-file filespec)
    (sys::open-output-file filespec)))

(defmacro with-open-file ((var filespec &rest other-args) &body body)
  `(let ((,var (open filespec ,@other-args)))
     (unwind-protect (progn ,@body)
       (close ,var))))

(defmacro with-output-to-string ((var &rest args) &body body) ;; not support options
  `(let ((,var (sys::make-string-output-stream)))
     ,@body
     (sys::string-output-stream-body ,var)))

(defun sys::conc-string (&rest args) ;; (concatenate 'string &rest args)
  (with-output-to-string (s)
    (dolist (a args)
      (princ a s))))

;; test implementation defstruct
(defmacro defstruct (name &rest args)
  (let ((slots (mapcar #'(lambda (x)
                           (if (consp x) (car x) x)) args)))
    `(progn
       (defun ,(intern (sys::conc-string "make-" name)) (&key ,@args)
         (let ((ans (make-array ,(length args))))
           ,@(let ((forms nil))
               (do* ((i 0 (+ i 1))
                    (tmp slots (cdr tmp))
                    (init (car tmp) (car tmp)))
                   ((null tmp) forms)
                 (push `(setf (aref ans ,i) ,init) forms)))
               ans))
      ,@(let ((macros nil))
          (do* ((i 0 (+ i 1))
               (tmp slots (cdr tmp))
               (slot (car tmp) (car tmp)))
              ((null tmp) macros)
            (push `(defmacro ,(intern (sys::conc-string name "-" slot)) (arg)
                     `(aref ,arg ,,i)) macros)))
       ',name)))

(defmacro assert (test &optional (error-message "assert failed"))
  (let ((tested (gensym)))
  `(let ((,tested ,test))
     (unless ,tested
       (error ,error-message)))))
;; package system API
(defun in-package (symbol-or-package)
  (let ((pack (if (symbolp symbol-or-package)
                  (find-package (string symbol-or-package))
                  symbol-or-package)))
    (setf *package* pack)))

(defun expand-defpackage-options (option-clause package-sym)
  (case (car option-clause)
    (:nickname `(setf (package-nickname ,package-sym) (string ,(cadr option-clause))))
    (:use `(progn ,@(mapcar #'(lambda (x) `(use-package (find-package (string ,x)) ,package-sym))
                              (cdr option-clause))))
    (:export `(let ((current *package*))
                (in-package ,package-sym)
                ,@(mapcar #'(lambda (x) `(export (intern (string ,x))))
                               (cdr option-clause))
                (in-package current)))
    (t (error "Unknown defpackage option"))))

(defmacro defpackage (name &rest options)
  (let ((name-string (gensym))
        (pack (gensym)))
  `(let* ((,name-string (string ,name))
          (,pack (let ((found (find-package ,name-string)))
                  (if found
                      found
                      (make-package ,name-string)))))
    ,@(mapcar #'(lambda (x) (expand-defpackage-options x pack)) options)
    ,pack)))

;; trace and untrace
(defmacro trace (&rest specs)
  (let ((names (gensym)))
    `(do ((,names ',specs (cdr ,names)))
         ((null ,names) ,@(mapcar #'(lambda (x) `(ftrace ',x)) specs) ',specs)
       (fdefinition (car ,names)))))
(defmacro untrace (&rest specs)
  (if specs
  `(progn ,@(mapcar #'(lambda (x) `(funtrace ',x)) specs) ',specs)
  `(maphash #'(lambda (k v) (funtrace k)) sys::*trace-table*)))

;; original part -- ruby <-> lisp interface
(set-dispatch-macro-character #\# #\[
  #'(lambda (stream char1 char2) `(lri::ruby-eval ,(read-string #\] stream))))

;; finally defpackage cl-user
(defpackage :common-lisp-user
  (:nickname :cl-user)
  (:use :cl))