# lisp condition system root
class LCondition < Exception
  def initialize
  end
  def invoke
    print "Error -- unknown lisp condition #{self.inspect}\n"
    print "\n"
    loop{
      print "Choose a restart;\n1:Abort\n"
      res = read
      if res == 1
        $trace_level=0
        print "Evaluation aborted.\n"
        break
      else
        print "No choice of restart! Please abort\n"
      end}
  end
end

class LsimpleError < LCondition
 attr_accessor :continuation, :repl_message, :protected
 def initialize (message,cc)
   @repl_message=message
   @continuation=cc
   @protected=[]
 end
 def restart (value)
   @continuation.call(value)
 end
 def invoke
   print @repl_message
   print "\n"
   print "Choose a restart;\n1:Abort\n2:Use another value for this expression\n"
   begin
     res = readline
     if res == "1\n" or res == "q\n"
       @protected.each{|x| x.call}
       $trace_level=0
       print "Evaluation aborted.\n"
     elsif res == "2\n"
       print "Type a value of instead; "
       value=(begin
                lisp_eval(read)
                lisp_value_pop
              #new debugger start
              rescue  LCondition => c
                c.invoke
              end)
       if value
         self.restart(value)
       else
         nil
       end
     else
       print "Type 1 or 2!\n\n"
       self.invoke
     end
   rescue Interrupt
     print "\nInterrupt by user break.\n"
     $trace_level=0
     nil
   end
 end
end

def error (message)
  callcc{|cc|
    raise LsimpleError.new(message,cc)
    }
end

class Lblockcondition < LCondition
  attr_accessor :name, :values
  def initialize (name,values)
    @name=name
    @values=values
  end
  def invoke
    print "Error -- block #{self.name.inspect} not found\n"
    print "\n"
    loop{
      print "Choose a restart;\n1:Abort\n"
      res = read
      if res == 1
        $trace_level=0
        print "Evaluation aborted.\n"
        break
      else
        print "No choice of restart! Please abort\n"
      end}
  end
end

class Ltagcondition < LCondition
  attr_accessor :tag
  def initialize (tag)
    @tag=tag
  end
  def invoke
    print "Error -- tag #{self.tag.inspect} not found\n"
    print "\n"
    loop{
      print "Choose a restart;\n1:Abort\n"
      res = read
      if res == 1
        $trace_level=0
        print "Evaluation aborted.\n"
        break
      else
        print "No choice of restart! Please abort\n"
      end}
  end
end

class Lthrowcondition < LCondition
  attr_accessor :name, :values
  def initialize (name,values)
    @name=name
    @values=values
  end
  def invoke
    print "Error -- throwing #{self.name.inspect} reached toplevel\n"
    print "\n"
    loop{
      print "Choose a restart;\n1:Abort\n"
      res = read
      if res == 1
        $trace_level=0
        print "Evaluation aborted.\n"
        break
      else
        print "No choice of restart! Please abort\n"
      end}
  end
end