class Loperator
  attr_accessor :trace
end

class Lfunction < Loperator
end

$trace_level=0

class LPrimitivefunction < Lfunction
  attr_accessor :name, :need_bind
  def initialize (name,block)
    @closure = block
#    @trace=true
    if name
      @name = name
    else
      @name = "unnmaed"
    end
  end
  def call(binding,*arglist)
    if @trace
      $trace_level.times{|x| print "  "}
      print $trace_level,": "
      print "(", self.name.inspect
      arglist.each{|x| print " ", x.inspect}
      print ")\n"
      $trace_level+=1
    end
    if @need_bind
      @closure.call(binding,*arglist)
    else
      begin
        @closure.call(*arglist)
      rescue => e
        $lisp_value_stack =[(error "base Ruby encounts the error; #{e.message}\n")]
      end
    end
    if @trace
      $trace_level-=1
      $trace_level.times{|x| print "  "}
      print $trace_level,": "
      print "returned"
      $lisp_value_stack.each{|x| print " ", x.inspect}
      print "\n"
    end
  end
  def inspect
    "#<Function #{@name.inspect}>"
  end
end

class LInterpretedfunction < Lfunction
  attr_accessor :name, :body, :arglist, :macrop
  def initialize (name,arglist,body)
    @arglist=arglist
    @body=body
    @macrop = nil
#    @trace=true
    if name
      @name = name
    else
      @name = "unnamed"
    end
  end
  def call(args,ext_binding)
    if @trace
      $trace_level.times{|x| print "  "}
      print $trace_level,": "
      print "(", self.name.inspect
      args.to_array.each{|x| print " ", x.inspect}
      print ")\n"
      $trace_level+=1
    end
    begin
      new_bind=@arglist.makeup_argument_bind(args,ext_binding)
    rescue LargumentError => e
      error "#{@name.inspect} -- #{e.m_or_f} argument passed\n"
    end
    eval_progn(@body,new_bind)
    if @trace
      $trace_level-=1
      $trace_level.times{|x| print "  "}
      print $trace_level,": "
      print "returned"
      $lisp_value_stack.each{|x| print " ", x.inspect}
      print "\n"
    end
  end
  def assume_macro
    @macrop = true
  end
  def inspect
    "#<#{(if @macrop
            "macro"
          else
            "Interpreted"
          end)} Function #{@name.inspect}>"
  end
end

def is_macro? (fn)
  fn.is_a?(LInterpretedfunction) and fn.macrop
end

class LargumentError < Exception
  attr_accessor :m_or_f
  def initialize (type)
    @m_or_f=type
  end
end

class Lcompiledarglist
  attr_accessor :static, :optional, :rest, :keyword, :aux
  def initialize (arglist,binding)
    @static=[]
    @optional=[]
    @keyword=[]
    @aux=[]
    self.compile_arglist(arglist,binding)
  end
  def compile_arglist(arglist,binding)
    if arglist==$lisp_nil
      nil
    else
      car = arglist.car
      case car
      when find_symbol("&optional","cl")
        self.compile_optional(arglist.cdr,binding)
      when find_symbol("&rest","cl"), find_symbol("&body","cl")
        self.compile_rest(arglist.cdr,binding)
      when find_symbol("&key","cl")
        self.compile_keyword(arglist.cdr,binding)
      when find_symbol("&aux","cl")
        self.compile_aux(arglist.cdr,binding)
      else
        @static.push(car)
        self.compile_arglist(arglist.cdr,binding)
      end
    end
  end
  def compile_optional (arglist,binding)
    if arglist==$lisp_nil
      nil
    else
      car = arglist.car
      case car
      when find_symbol("&rest","cl"), find_symbol("&body","cl")
        self.compile_rest(arglist.cdr,binding)
      when find_symbol("&key","cl")
        self.compile_keyword(arglist.cdr,binding)
      when find_symbol("&aux","cl")
        self.compile_aux(arglist.cdr,binding)
      else
        if car.is_a?(Cons)
          passedp=car.cdr.cdr.car
          tmp=[]
          if passedp
            tmp=[car.car,compile_body(car.cdr.car,binding),passedp]
          else
            tmp=[car.car,compile_body(car.cdr.car,binding)]
          end
          @optional.push(tmp)
          self.compile_optional(arglist.cdr,binding)
        else
          @optional.push([car,$lisp_nil])
          self.compile_optional(arglist.cdr,binding)
        end
      end
    end
  end
  def compile_rest (arglist,binding)
    @rest=arglist.car
    case arglist.cdr.car
    when find_symbol("&key","cl")
      self.compile_keyword(arglist.cdr.cdr,binding)
    when find_symbol("&aux","cl")
      self.compile_aux(arglist.cdr,binding)
    when $lisp_nil
      nil
    else
      error "Illegal arglist\n"
    end
  end
  def compile_keyword (arglist,binding)
    if arglist==$lisp_nil
      nil
    else
      car = arglist.car
      case car
      when find_symbol("&aux","cl")
        self.compile_aux(arglist.cdr,binding)
      else
        if car.is_a?(Cons)
          passedp=car.cdr.cdr.car
          tmp=[]
          if not(passedp==$lisp_nil)
            tmp=[car.car,compile_body(car.cdr.car,binding),passedp]
          else
            tmp=[car.car,compile_body(car.cdr.car,binding)]
          end
          @keyword.push(tmp)
          self.compile_keyword(arglist.cdr,binding)
        else
          @keyword.push([car,$lisp_nil])
          self.compile_keyword(arglist.cdr,binding)
        end
      end
    end
  end
  def compile_aux (arglist,binding)
    if arglist==$lisp_nil
      nil
    else
      car=arglist.car
      if car.is_a?(Cons)
        @aux.push([car.car,compile_body(car.cdr.car,binding)])
      else
        @aux.push([car,$lisp_nil])
      end
    self.compile_aux(arglist.cdr,binding)
    end
  end
  def makeup_argument_bind (args,ext_binding)
    new=[]
    @static.each{|x|
      if args.is_a?(Cons)
        push_bind(x,args.car,new,ext_binding)
        args=args.cdr
      else
        raise LargumentError.new("few")
      end}
    @optional.each{|x|
      if args.is_a?(Cons)
        push_bind(x,args.car,new,ext_binding)
        args=args.cdr
      else
        push_bind(x,nil,new,ext_binding)
      end}
    # binding rest arguments
    if @rest
      push_bind(@rest,args,new,ext_binding)
    end
    # first collect passed keyword argument
    found_keys=[]
    loop{
      car=args.car
      if car.is_a?(Lsymbol) and car.package==$key_package
        place=@keyword.find{|x| x[0].name==car.name}
        if place
          found_keys.push([place,args.cdr.car])
          args=args.cdr.cdr
        else
          error "Error -- not exist keyword argument names #{car.inspect}\n" #add allow-other-keys option here.
        end
      else
        break
      end}
    # and growing up binding
    @keyword.each{|x|
      found = found_keys.find{|y| y[0][0]==x[0]}
      if found
        push_bind(x,found[1],new,ext_binding)
      else
        push_bind(x,nil,new,ext_binding)
      end}
    if not(@rest) and args.is_a?(Cons)  # more complex check is required for allow-other-keys
        raise LargumentError.new("much")
    end
    @aux.each{|x|
      push_bind(x,nil,new,ext_binding)}
    [[ext_binding[0]]+new,ext_binding[1],ext_binding[2]]
  end
  def dummy_bind (ext_binding)
    new=[]
    @static.each{|x|
      push_dummy(x,new)}
    @optional.each{|x|
      push_dummy(x,new)}
    if @rest
      new.push([@rest,:dynamic])
    end
    @keyword.each{|x|
      push_dummy(x,new)}
    [[ext_binding[0]]+new,ext_binding[1],ext_binding[2]]
  end
end

def push_bind (receiver,arg,arg_bind,ext_binding)
  if receiver.is_a?(Array)
    if arg
      arg_bind.push([receiver[0],arg])
      if receiver[2]
        arg_bind.push([receiver[2],$t])
      end
    else
      arg_bind.push([receiver[0],(lisp_eval(receiver[1],[[ext_binding[0]]+arg_bind,ext_binding[1],ext_binding[2]]);lisp_value_pop)])
      if receiver[2]
        arg_bind.push([receiver[2],$lisp_nil])
      end
    end
  else
    arg_bind.push([receiver,arg])
  end
end

def push_dummy (receiver,new_bind)
  if receiver.is_a?(Array)
    new_bind.push([receiver[0],:dynamic])
    if receiver[2]
      new_bind.push([receiver[2],:dynamic])
    end
  else
    new_bind.push([receiver,:dynamic])
  end
end

def set_func_name (func,name)
  func.name = name
end

Lsymbol.new("&optional","cl")
Lsymbol.new("&key","cl")
Lsymbol.new("&rest","cl")
Lsymbol.new("&body","cl")
Lsymbol.new("&whole","cl")
Lsymbol.new("&environment","cl")
Lsymbol.new("&aux","cl")

# destructuring-bind helper functions
def destruc_top (pat,form)
  if pat==$lisp_nil
    $lisp_nil
  elsif pat.car==find_symbol("&whole","cl")
    Cons.new(list(pat.cdr.car,form),destruc_ord(pat.cdr.cdr,form))
  else
    destruc_ord(pat,form)
  end
end

# for error check in destructuring-bind, ordinary argument founder is needed.
# This function will be bound for sys::car-fuzzy.
def car_fuzzy (x,symbol)
  if x==$lisp_nil
    error "not found place of symbol #{symbol.inspect}\n"
  else
    x.car
  end
end

def destruc_ord (pat,form)
  if pat==$lisp_nil
    $lisp_nil
  else
    if not(pat.is_a?(Cons))
      list(list(pat,form))
    else
      p = pat.car
      case p
      when find_symbol("&optional","cl")
        destruc_opt(pat.cdr,form)
      when find_symbol("&rest","cl"), find_symbol("&body","cl")
        destruc_rest(pat.cdr,form)
      when find_symbol("&key","cl")
        destruc_key(pat.cdr,form)
      when find_symbol("&aux","cl")
        destruc_aux(pat.cdr)
      else
        cdrsym = Lsymbol.new(nil,nil)
        rec = destruc_ord(pat.cdr,cdrsym)
        cdr_binds = (if not(pat.cdr==$lisp_nil or pat.cdr.car==find_symbol("&aux","cl"))
                        Cons.new(list(cdrsym,list(find_symbol("cdr","cl"),form)),rec)
                     else
                        rec
                     end)
        if not(p.is_a?(Cons))
          Cons.new(list(p,list(find_symbol("car-fuzzy","sys"),form,list(find_symbol("quote","cl"),p))),cdr_binds)
        else
          carsym = Lsymbol.new(nil,nil)
          append(list(list(carsym,list(find_symbol("car-fuzzy","sys"),form,list(find_symbol("quote","cl"),p)))),
                 destruc_top(p,carsym),
                 cdr_binds)
        end
      end
    end
  end
end

def destruc_opt (pat,form)
  if pat==$lisp_nil
    $lisp_nil
  else
    p = pat.car
    case p
    when find_symbol("&rest","cl"), find_symbol("&body","cl")
      destruc_rest(pat.cdr,form)
    when find_symbol("&key","cl")
      destruc_key(pat.cdr,form)
    when find_symbol("&aux","cl")
      destruc_aux(pat.cdr)
    else
      cdrsym = Lsymbol.new(nil,nil)
      rec = destruc_opt(pat.cdr,cdrsym)
      cdr_binds = (if not(rec==$lisp_nil)
                      Cons.new(list(cdrsym,list(find_symbol("cdr","cl"),form)),rec)
                   else
                      $lisp_nil
                   end)
      main_var = (if p.is_a?(Cons)
                    p.car
                  else
                    p
                  end)
      default = (if p.is_a?(Cons)
                   p.cdr.car
                 else
                   $lisp_nil
                 end)
      passed_p_var = (if p.is_a?(Cons) and not(p.cdr.cdr==$lisp_nil)
                        p.cdr.cdr.car
                      else
                        nil
                      end)
      this_bind = list(main_var,list(find_symbol("if","cl"),list(find_symbol("car","cl"),form),list(find_symbol("car","cl"),form),default))
      if passed_p_var
        Cons.new(this_bind,Cons.new(list(passed_p_var,list(find_symbol("if","cl"),list(find_symbol("car","cl"),form),$t,$lisp_nil)),cdr_binds))
      else
        Cons.new(this_bind,cdr_binds)
      end
    end
  end
end

def destruc_rest (pat,form)
  p = pat.car
  if p==$lisp_nil
    error "Illegal detructuring-lambda-list\n"
  else
    rec=(case pat.cdr.car
         when find_symbol("&key","cl")
           desturc_key(pat.cdr.cdr,form)
         when find_symbol("&aux","cl")
           destruc_aux(pat.cdr)
         when $lisp_nil
           $lisp_nil
         else
           error "Illegal detructuring-lambda-list\n"
         end)
    Cons.new(list(p,form),rec)
  end
end

# to use destruc_key, need lisp-function to search keyword argument!
# This function will be bound to sys::keylookup -- returning [found,value]
def keylookup (symbol,form)
  if form==$lisp_nil
    [$lisp_nil,$lisp_nil]
  else
    acar=form.car
    acdr=form.cdr
    if not(acdr.is_a?(Cons))
      error "Odd arguments passed to keyword arguments.\n"
    end
    if symbol==acar
      [$t,acdr.car]
    else
      keylookup(symbol,acdr.cdr)
    end
  end
end

def make_keyword_binder (symbol,form,default)
  valuesym=Lsymbol.new(nil,nil)
  foundsym=Lsymbol.new(nil,nil)
  list(find_symbol("multiple-value-bind","cl"),list(foundsym,valuesym),
       list(find_symbol("keylookup","sys"),read_intern(symbol.name,"keyword"),form),
       list(find_symbol("if","cl"),foundsym,valuesym,default))
end

def make_keyword_passedp_binder (symbol,form)
  list(find_symbol("keylookup","sys"),read_intern(symbol.name,"keyword"),form)
end

def destruc_key (pat,form)
  this_bind=[]
  rec=$lisp_nil
  loop{
    p = pat.car
    if p==$lisp_nil # add &aux, &allow-other-keys exit
      break
    elsif p==find_symbol("&aux","cl")
      rec=destruc_aux(pat.cdr)
      break
    elsif p.is_a?(Lsymbol)
      this_bind.push(list(p,make_keyword_binder(p,form,$lisp_nil)))
    else
      var=p.car
      default=p.cdr.car
      passedp=(if p.cdr.cdr.is_a?(Cons)
                 p.cdr.cdr.car
               else
                 nil
               end)
      this_bind.push(list(var,make_keyword_binder(var,form,default)))
      if passedp
        this_bind.push(list(passedp,make_keyword_passedp_binder(var,form)))
      end
    end
    pat=pat.cdr}
  append(list(*this_bind),rec)
end

def destruc_aux (pat)
  if pat==$lisp_nil
    $lisp_nil
  else
    p=pat.car
    rec=destruc_aux(pat.cdr)
    this_bind=(if p.is_a?(Lsymbol)
                 list(p,$lisp_nil)
               else
                 p
               end)
    Cons.new(this_bind,rec)
  end
end

def analyze_mllist (mllist)
  destlist = []
  env = $lisp_nil
  loop{
    if mllist==$lisp_nil
      break
    else
      car=mllist.car
      if car==find_symbol("&environment","cl")
        env=mllist.cdr.car
        break
      else
        destlist.push(car)
        mllist=mllist.cdr
      end
    end}
  [mk_dest_for_macro(destlist),env] # multiple-value return.
end

def mk_dest_for_macro(destlist)
  tmp=[]
  if destlist[0]==find_symbol("&whole","cl")
    tmp=destlist[0,2]+[Lsymbol.new(nil,nil)]+destlist[2,destlist.length]
  else
    tmp=[Lsymbol.new(nil,nil)]+destlist
  end
  list(*tmp)
end

def eval_function (symbol_or_lambda,binding,forcep = nil)
  if symbol_or_lambda.is_a?(Lsymbol)
    tmp = lookup_function(symbol_or_lambda,binding)
    if not(forcep) and (tmp.is_a?(Lspecial) or is_macro?(tmp))
      error "Error -- #{symbol_or_lambda.inspect} is name of macro or special form\n"
    else
      $lisp_value_stack = [tmp]
    end
  elsif symbol_or_lambda.is_a?(Cons) and symbol_or_lambda.car == find_symbol("lambda","cl")
    arglist=Lcompiledarglist.new(symbol_or_lambda.cdr.car,binding)
    dummy_bind = arglist.dummy_bind(binding)
    bodytmp = mapcar(lambda{|x| compile_body(x,dummy_bind)},symbol_or_lambda.cdr.cdr)
    $lisp_value_stack = [LInterpretedfunction.new(nil,arglist,bodytmp)]
  elsif symbol_or_lambda.is_a?(Lcompiledargument)
    $lisp_value_stack = [symbol_or_lambda.found_function(binding)]
  else
    error "Error -- bad arg for function #{symbol_or_lambda.inspect}\n"
  end
end

# !! simple compile of closure !!
class Lcompiledargument
  attr_accessor :type, :address, :binding
  def initialize (type,address, binding = nil)
    @type=type
    @address=address
    @binding=binding
  end
  def found_binding ()
    if @type==:lexical
      @binding
    else
      nil
    end
  end
  def found_value (dynamic)
    if @type==:lexical
      @binding[1]
    elsif @type==:dynamic
      #print "lookup #{@address.inspect} in dynamic #{dynamic.inspect}\n"
      get_address(@address,dynamic[0])[1]
    else
      lookup_value(@address,dynamic)
    end
  end
  def found_function (dynamic)
    if @type==:lexical
      @binding[1]
    elsif @type ==:special
      @address.symbol_function
    else
      get_address(@address,dynamic[1])[1]
    end
  end
  def found_block_name (dynamic)
    if @type==:lexical
      @binding[1]
    else
      #print "lookup #{@address.inspect} in dynamic #{dynamic.inspect}\n"
      get_address(@address,dynamic[2])[1]
    end
  end
  def inspect
    "#<compiled argument #{@type.inspect} #{if @type==:lexical
                                              @binding[0].inspect
                                            else
                                              address.inspect
                                            end}>"
  end
end

# special form
class Lspecial < Loperator
  attr_accessor :name, :compile, :eval
  def initialize (name,block)
    @compile = block
    @name = name
#    @trace = true
  end
  def call(sexp,binding)
    if @trace
      $trace_level.times{|x| print "  "}
      print $trace_level,": "
      print "(", self.name, " "
      print sexp.inspect
      print ")\n"
      $trace_level+=1
    end
      @eval.call(sexp,binding)
    if @trace
      $trace_level-=1
      $trace_level.times{|x| print "  "}
      print $trace_level,": "
      print "returned"
      $lisp_value_stack.each{|x| print " ", x.inspect}
      print "\n"
    end
  end
  def compile(sexp,binding)
    @compile.call(sexp,binding)
  end
  def inspect
    "#<Special-form #{@name}>"
  end
end

def defspecial (name,ruby_name)
  eval "Lsymbol.new(\"#{name}\",\"cl\").function=Lspecial.new(\"#{name}\",lambda{|sexp,binding| #{ruby_name}(sexp,binding)})"
end

def compile_body (body,binding)
  #print "compiling #{body.inspect} in #{binding.inspect}\n"
  if body == $lisp_nil
    $lisp_nil
  elsif body.is_a?(Lsymbol)
    compile_arg(body,binding)
  else
    expand=macroexpand(body,binding)
    if expand.is_a?(Cons)
      operator=compile_operator(expand.car,binding)
      if operator.is_a?(Lspecial)
        operator.compile(expand,binding)
      else
        compile_default(operator,expand.cdr,binding)
      end
    else
      expand
    end
  end
end

def compile_operator (sexp,binding)
  #print "compiling function name #{sexp.inspect}\n"
  if sexp.is_a?(Lsymbol)
    add=find_address(sexp,binding[1])
    if add
      if add[0] == :dynamic
        Lcompiledargument.new(:dynamic,add[1],nil)
      else
        Lcompiledargument.new(:lexical,add[1],add[0])
      end
    else
      global=(begin
                sexp.function
              rescue
                nil
              end)
      if global.is_a?(Lspecial)
        global
      else
        Lcompiledargument.new(:special,sexp)
      end
    end
  else
    eval_function(sexp,binding,true)
    closure=lisp_value_pop
    Lcompiledargument.new(:lexical,nil,[nil,closure])
  end
end

def find_address (symbol,binding,level = 0)
  if binding[0] == :toplevel
    nil
  else found = binding.find_pos(1){|x| x[0]==symbol}
    if found
      fb=binding[found]
      if fb[1].is_a?(Symbol)
        [fb[1],[level,found]]
      elsif fb[1].is_a?(LSymbolmacro)
        [:smlet,fb[1].body]
      else
        [fb,[level,found]]
      end
    else
      find_address(symbol,binding[0],level+1)
    end
  end
end

def get_address (address,binding)
  #print "lookup finding #{address.inspect} in #{binding.inspect}\n"
  address[0].times{
    binding=binding[0]}
  binding[address[1]]
end

def compile_arg (symbol,binding)
  add=find_address(symbol,binding[0])
  if symbol.special
    if add and add[0] == :smlet
      error "symbol-macrolet symbol #{symbol.inspect} is globally declared SPECIAL\n"  # fix me!
    else
      Lcompiledargument.new(:special,symbol)
    end
  else
    if add
      if add[0] == :dynamic
        Lcompiledargument.new(:dynamic,add[1],nil)
      elsif add[0] == :smlet
        compile_body(add[1],binding)
      else
        Lcompiledargument.new(:lexical,add[1],add[0])
      end
    else
       Lcompiledargument.new(:special,symbol)
    end
  end
end

def compile_block_name (symbol,binding)
  add=find_address(symbol,binding)
  if add
    if add[0] == :dynamic
      Lcompiledargument.new(:dynamic,add[1],nil)
    else
      Lcompiledargument.new(:lexical,add[1],add[0])
    end
  else
    error "compile error -- return-from coudn't found block name #{symbol.inspect}\n"
  end
end

def compile_default (op,sexp,binding)
  Cons.new(op,mapcar(lambda{|x| compile_body(x,binding)},sexp))
end

def compile_default_special (sexp,binding)
  Cons.new(sexp.car,mapcar(lambda{|x| compile_body(x,binding)},sexp.cdr))
end

def compile_quote (sexp,binding)
  sexp
end

def compile_let (sexp,binding)
  new_binds = mapcar(lambda{|x| list(x.car,compile_body(x.cdr.car,binding))},sexp.cdr.car)
  tmp_s_v = mapcar(lambda{|x| Cons.new(x.car,:dynamic)},new_binds)
  next_binding = extend_vbinding(tmp_s_v,binding)
  new_body = mapcar(lambda{|x| compile_body(x,next_binding)},sexp.cdr.cdr)
  Cons.new(sexp.car,Cons.new(new_binds,new_body))
end

def compile_flet (sexp,binding)
  tmp_s_v = mapcar(lambda{|x| Cons.new(x.car,:dynamic)},sexp.cdr.car)
  next_binding = extend_fbinding(tmp_s_v,binding)
  new_body = mapcar(lambda{|x| compile_body(x,next_binding)},sexp.cdr.cdr)
  Cons.new(sexp.car,Cons.new(sexp.cdr.car,new_body))
end

def compile_macrolet (sexp,binding)  # fix me! I give up macrolet compiling
  sexp
end


def compile_labels (sexp,binding)
  tmp_s_v = mapcar(lambda{|x| Cons.new(x.car,:dynamic)},sexp.cdr.car)
  next_binding = extend_fbinding(tmp_s_v,binding)
  new_body = mapcar(lambda{|x| compile_body(x,next_binding)},sexp.cdr.cdr)
  Cons.new(sexp.car,Cons.new(sexp.cdr.car,new_body))
end

def compile_function (sexp,binding)
  sexp
end

class LSymbolmacro < Lfunction
  attr_accessor :body
  def initialize (body)
    @body=body
  end
  def call(ext_binding)
    lisp_eval(@body,ext_binding)
  end
end

def compile_smlet (sexp,binding)
  tmp_s_v = mapcar(lambda{|x| Cons.new(x.car,LSymbolmacro.new(x.cdr.car))},sexp.cdr.car)
  next_binding = extend_vbinding(tmp_s_v,binding)
  new_body = mapcar(lambda{|x| compile_body(x,next_binding)},sexp.cdr.cdr)
  Cons.new(sexp.car,Cons.new(sexp.cdr.car,new_body))
end

def compile_mvbind (sexp,binding)
  new_mvform = compile_body(sexp.cdr.cdr.car,binding)
  tmp_s_v = mapcar(lambda{|x| Cons.new(x,:dynamic)},sexp.cdr.car)
  next_binding = extend_vbinding(tmp_s_v,binding)
  new_body = mapcar(lambda{|x| compile_body(x,next_binding)},sexp.cdr.cdr.cdr)
  Cons.new(sexp.car,Cons.new(sexp.cdr.car,Cons.new(new_mvform,new_body)))
end

def compile_block (sexp,binding)
  next_bind = extend_bbinding(sexp.cdr.car,:dynamic,binding)
  Cons.new(sexp.car,Cons.new(sexp.cdr.car,mapcar(lambda{|x| compile_body(x,next_bind)},sexp.cdr.cdr)))
end

def compile_return_from (sexp,binding)
  Cons.new(sexp.car,Cons.new(compile_block_name(sexp.cdr.car,binding[2]),mapcar(lambda{|x| compile_body(x,binding)},sexp.cdr.cdr)))
end

def compile_tagbody (sexp,binding)
  Cons.new(sexp.car,mapcar(lambda{|x| if x.is_a?(Lsymbol)
                                        x
                                      else
                                        compile_body(x,binding)
                                      end},sexp.cdr))
end

def compile_go (sexp,binding)
  sexp
end

def compile_catch (sexp,binding)
  Cons.new(sexp.car,Cons.new(sexp.cdr.car,mapcar(lambda{|x| compile_body(x,binding)},sexp.cdr.cdr)))
end

def compile_throw (sexp,binding)
  Cons.new(sexp.car,Cons.new(sexp.cdr.car,mapcar(lambda{|x| compile_body(x,binding)},sexp.cdr.cdr)))
end

["let",
"quote",
"flet",
"macrolet",
"labels",
"function",
"block",
"tagbody",
"go",
"catch",
"throw",].each{|x| defspecial(x,"compile_#{x}")}

["setq",
"psetq",
"if",
"progn",
"ignore-errors",
"unwind-protect"].each{|x| defspecial(x,"compile_default_special")}

defspecial("symbol-macrolet","compile_smlet")
defspecial("multiple-value-bind","compile_mvbind")
defspecial("return-from","compile_return_from")