require "stringio"

$interaction = lambda{readline}

class Lstream
end

class Linputstream < Lstream
  def initialize (ruby_stream = nil)
    if ruby_stream
      if ruby_stream.is_a?(StringIO)
        @file = "string-simple-stream"
        @sfun = lambda{""}
        @stringio = ruby_stream
      else
        @file = ruby_stream
        @sfun = lambda{ruby_stream.readline}
        @stringio = StringIO.new
      end
    else
      @file = "interaction"
      @sfun = $interaction
      @stringio = StringIO.new
    end
  end
  def inspect
    "#<simple-stream input " + @file.inspect + ">"
  end
  def fast_read_top
    if @stringio.eof
      newline = @sfun.call
      if newline.size == 0
        error "Unexpected EOF\n"
      else
        pos = @stringio.pos
        @stringio.string = @stringio.string + newline
        @stringio.pos = pos
      end
    end
    @stringio.string[@stringio.pos]
  end
  def string
    @stringio.string
  end
  def pos
    @stringio.pos
  end
  def read (x)
    @stringio.read(x)
  end
  def close
    if @file.is_a?(File)
      @file.close
    end
  end
end

class Loutputstream < Lstream
  def initialize (ruby_stream = nil)
    if ruby_stream
      @file = ruby_stream
      @output = lambda{|string| ruby_stream.print(string)}
    else
      @file = "string-output-stream"
      @output = ""
    end
  end
  def inspect
    "#<simple-stream output " + @file.inspect + ">"
  end
  def write (string)
    if @output.is_a?(String)
      @output=@output+string
    else
      @output.call(string)
    end
  end
  def string
    if @output.is_a?(String)
      @output
    else
      error "#{self.inspect} is not string stream.\n"
    end
  end
  def close
    if @file.is_a?(File)
      @file.close
    end
  end
end

def make_string_input_stream (string, start = nil, finnish = nil)
  if finnish
    string=string[0,finnish]
  end
  if start
    string=string[start,string.length]
  end
  Linputstream.new(StringIO.new(string+"\n"))
end

def open_file_input (filename)
  Linputstream.new(File.open(filename))
end

def open_file_output (filename)
  Loutputstream.new(File.open(filename,"w"))
end