$package_table = {}

class Lpackage
  attr_accessor :name, :nickname, :table, :use_list
  def initialize (name)
    @name = name
    @table = {}
    @use_list = []
    @nickname = name
    $package_table[name] = self
  end
  def inspect
    "#<The " + @name + " package>"
  end
  def nickname= (name)
    $package_table[name] = self
    @nickname = name
  end
end

def find_package (name)
  if name.is_a?(Lsymbol)
    name=name.name
  end
  $package_table[name]
end

Lpackage.new("common-lisp").nickname = "cl"
$key_package=Lpackage.new("keyword")
$key_package.nickname = "keyword"
Lpackage.new("system").nickname = "sys"

class Lsymbol
  attr_accessor :name, :package, :value, :function, :plist, :exported, :vartype, :flock
  def initialize (name,package)
    if package.is_a?(String)
      package=find_package(package)
    end
    @name = name
    @package = package
    @value = :unbound
    @function = :unbound
    @plist = $lisp_nil
    if package==$key_package
      @exported = true
    else
      @exported = nil
    end
    @special = nil
    if package
      package.table[name] = self
    end
  end
  def inspect
    (if @package.nil?
      "#:"
    elsif @package == $key_package
      ":"
    elsif find_symbol(@name)
      ""
    elsif @exported
      @package.nickname + ":"
    else
      @package.nickname + "::"
    end) + (if @name.nil?
              "G#{self.object_id}"
            else
              @name
            end)
  end
  def set_symbol_value(new)
    if @vartype==:constant
      error "Attempt to change the value of constat variable #{self.inspect}.\n"
    else
      self.value=new
    end
  end
  def set_symbol_function(new)
    if @flock
      error "Attempt to change the ANSI function definition #{self.inspect}. This change is dangerous.\n"
    else
      self.function=new
    end
  end
  def symbol_value
    if @package == $key_package
      self
    elsif @value == :unbound
      error "Attempt to take the value of the unbound variable #{self.inspect}.\n"
    else
      @value
    end
  end
  def symbol_function
    if @function == :unbound
      error "Attempt to call undefined function #{self.inspect}.\n"
    else
      @function
    end
  end
  def symbol_plist
    @plist
  end
  def symbol_name
    @name
  end
  def symbol_package
    @package
  end
  def special
    @vartype==:special
  end
  def constant
    @vartype==:constant
  end
  def assume_special
    if not(@vartype==:constant)
      @vartype = :special
    end
  end
  def assume_constant
    @vartype = :constant
  end
  def ansi_function_lock
    @flock = true
  end
end

$packsym=Lsymbol.new("*package*", find_package("cl"))
$packsym.value = find_package("cl")
$packsym.assume_special
$int=Lsymbol.new("internal","keyword")
$ext=Lsymbol.new("external","keyword")
$inh=Lsymbol.new("inherited","keyword")

def find_symbol_lisp (name, package = nil, forcep = nil)
  if package.nil?
    package = (find_symbol("*package*","cl")).symbol_value
  elsif package.is_a?(String)
    package = find_package(package)
  elsif package.is_a?(Lsymbol)
    package = find_package(package.name)
  end
  tmp=package.table[name]
  if forcep or tmp.exported
    nil
  else
    tmp=nil
  end
  if tmp
    if tmp.exported
      [tmp,$ext]
    else
      [tmp,$int]
    end
  else
    tmp=package.use_list.find_it{|x|
          find_symbol_external(name,x)}
    if tmp
      [tmp,$inh]
    else
      nil
    end
  end
end

def find_symbol (name, package = nil)
  tmp=find_symbol_lisp(name,package,true)
  if tmp
    tmp[0]
  else
    tmp
  end
end

def find_symbol_external(name, package)
  tmp=package.table[name]
  if tmp
    if tmp.exported
      tmp
    end
  else
    package.use_list.find_it{|x|
      find_symbol_external(name,x)}
  end
end

def intern (name, package = nil, forcep = nil)
  sym=nil
  found = nil
  if name.is_a?(Lsymbol)
    name = name.name
  end
  if package.nil?
    package = (find_symbol("*package*","cl")).symbol_value
    forcep = true
    found = find_symbol_lisp(name,package,forcep)
  else
    if package.is_a?(String)
      package = find_package(package)
    elsif package.is_a?(Lsymbol)
      package = find_package(package.name)
    end
    if package == (find_symbol("*package*","cl")).symbol_value or package == $key_package
      forcep = true
      found = find_symbol_lisp(name,package,forcep)
    elsif package
      found = find_symbol_lisp(name,package,forcep)
    else
      error "not found such package.\n"
    end
  end
  if found
    found
  elsif forcep
    [Lsymbol.new(name,package),$lisp_nil]
  else
    error "#{name} is not exported or not found in package #{package.inspect}\n"
  end
end

def read_intern (name, package = nil)
  if name[0] == ":"[0]
    intern(name[1,name.length],package,true)[0]
  else
    intern(name,package,nil)[0]
  end
end

def unintern (sym,package)
  if package.nil?
    package = (find_symbol("*package*","cl")).symbol_value
  elsif package.is_a?(String)
    package = find_package(package)
  elsif package.is_a?(Lsymbol)
    package = find_package(package.name)
  end
  name=sym.name
  tmp=package.table[name]
  if tmp
    package.table[name]=nil
    if tmp.package==package
      tmp.package=nil
    end
    $t
  else
    $lisp_nil
  end
end

$lisp_nil = Lsymbol.new("nil","cl")
$lisp_nil.assume_constant


# pakcage system API
def make_package (name)
  if name.is_a?(Lsymbol)
    name=name.name
  end
  if name.is_a?(String)
    Lpackage.new(name)
  else
    error "bad argument for make-package"
  end
end

def use_package (package, user = (find_symbol("*package*","cl")).symbol_value)
  if package.is_a?(String)
    package = find_package(package)
  elsif package.is_a?(Lsymbol)
    package = find_package(package.name)
  end
  if user.is_a?(String)
    user = find_package(user)
  elsif user.is_a?(Lsymbol)
    user = find_package(user.name)
  end
  package.table.each{|name,sym|
    if sym.exported
      found=user.table[name]
      if found
        error "failure use #{package.inspect} -- #{sym.inspect} is conflict with #{found.inspect}\n"
      end
    end}
  user.use_list.pushnew(package)
  $t
end

def package_use_list (package)
  if package.is_a?(String)
    package = find_package(package)
  elsif package.is_a?(Lsymbol)
    package = find_package(package.name)
  end
  list(*package.use_list)
end

def export (symbol)
  symbol.exported = true
  symbol
end

intern("lambda","cl")

def import (symbol, package = (find_symbol("*package*","cl")).symbol_value)
  name=symbol.name
  if package.table[name]
    error "import failed; symbol comfilct\n"
  else
    package.table[name] = symbol
    symbol
  end
end