def defprimitive (name,pack,&block) # only define one value returning funciton
  Lsymbol.new(name,pack).function=LPrimitivefunction.new(find_symbol(name,pack),lambda{|*args| $lisp_value_stack = [block.call(*args)]})
end

def plus (*args)
  if args.length==0
    0
  else
    args[0] + plus(*args[1,args.length])
  end
end

def minus (*args)
  if args.length==0
    0
  else
    let = args[0]
    rest = args[1,args.length]
    rest.each{|x|
      let = let - x}
    let
  end
end

def multi (*args)
  if args.length==0
    1
  else
    args[0] * multi(*args[1,args.length])
  end
end

def divide (*args)
  if args.length==0
    1
  else
    let = args[0]
    rest = args[1,args.length]
    rest.each{|x|
      let = let * Rational(1,x)}
    let
  end
end

def define_lisp_pred(name, ruby_pred)
  eval "def #{name} (*args)
          if args.length==1
            $t
          elsif args[0] #{ruby_pred} args[1]
            #{name}(*args[1,args.length])
          else
            $lisp_nil
          end
        end"
  eval  "defprimitive(\"#{ruby_pred}\",\"cl\"){|*args|
          #{name}(*args)}"
end

define_lisp_pred("lisp_bigger_than",">")
define_lisp_pred("lisp_smaller_than","<")
define_lisp_pred("lisp_bigger_equal",">=")
define_lisp_pred("lisp_smaller_equal","<=")

def neq (x,y)
  x.is_a?(Numeric) and y.is_a?(Numeric) and x == y
end

def number_eq (*args)
  if args.length==1
    $t
  elsif neq(args[0],args[1])
    number_eq(*args[1,args.length])
  else
    $lisp_nil
  end
end

# some constants
$lisp_nil.value = $lisp_nil
$t=Lsymbol.new("t","cl")
$t.value = $t
$t.assume_constant

defprimitive("+","cl"){|*args|
  plus(*args)}

defprimitive("-","cl"){|*args|
  minus(*args)}

defprimitive("*","cl"){|*args|
  multi(*args)}

defprimitive("/","cl"){|*args|
  divide(*args)}

defprimitive("=","cl"){|*args|
  number_eq(*args)}

defprimitive("mod","cl"){|x,y|
  x%y}

defprimitive("random","cl"){|x|
  if x.is_a?(Float)
    rand * x
  elsif x.is_a?(Integer)
    rand(x)
  else
    error "Illegral argument for random -- #{x.inspect}"
  end}

defprimitive("eq","cl"){|x,y|
  if x == y
    $t
  else
    $lisp_nil
  end}

defprimitive("eql","cl"){|x,y|
  if x == y
    $t
  else
    $lisp_nil
  end}

defprimitive("symbol-value","cl"){|x|
  x.symbol_value}

defprimitive("symbol-package","cl"){|x|
  x.symbol_package}

defprimitive(".set-symbol-value.","system"){|x,y|
  x.set_symbol_value(y)}

defprimitive("symbol-function","cl"){|x|
  x.symbol_function}

defprimitive(".set-symbol-function.","system"){|x,y|
  x.set_symbol_function(y)}

defprimitive(".set-function-name.","system"){|x,y|
  x.name=y}

defprimitive(".set-function-is-macro.","system"){|x|
  x.assume_macro
  x}

defprimitive("function-lambda-expression","cl"){|x|
  x.body}

defprimitive(".destruc-top","sys"){|pat,form|
  destruc_top(pat,form)}

defprimitive("car-fuzzy","sys"){|x,symbol|
  car_fuzzy(x,symbol)}

Lsymbol.new("keylookup","system").function=LPrimitivefunction.new(find_symbol("keylookup","system"),lambda{|symbol,form|
  $lisp_value_stack = keylookup(symbol,form)})

Lsymbol.new(".analyze-mllist","system").function=LPrimitivefunction.new(find_symbol(".analyze-mllist","system"),lambda{|mllist|
  $lisp_value_stack = analyze_mllist(mllist)})

defprimitive("package-nickname","cl"){|x|
  x.nickname}

defprimitive(".set-package-nickname.","system"){|x,y|
  x.nickname=y}

defprimitive("gensym","cl"){
  Lsymbol.new(nil,nil)}

defprimitive("symbol-plist","cl"){|x|
  x.plist}

defprimitive(".set-symbol-plist.","sys"){|x,y|
  x.plist=y}

defprimitive("symbol-name","cl"){|x|
  x.symbol_name}

class Lhash < Hash
  def inspect
    "#<eql hash table with #{self.size} entries>"
  end
end

defprimitive("make-hash-table","cl"){
  Lhash.new}

Lsymbol.new(".gethash1.","system").function=LPrimitivefunction.new(find_symbol(".gethash1.","system"),lambda{|key,table,default|
  tmp=table[key]
  if tmp
    $lisp_value_stack = [tmp,$t]
  else
    $lisp_value_stack = [default,$lisp_nil]
  end})

defprimitive(".sethash.","system"){|key,table,value|
  table[key]=value}

defprimitive("remhash","cl"){|key,table|
  found=table.delete(key)
  if found
    $t
  else
    $lisp_nil
  end}

defprimitive("clrhash","cl"){|table|
  table.delete_if{|key,value| true}
  table}

$trace_table=Lhash.new

Lsymbol.new("*trace-table*","sys").value=$trace_table

defprimitive("ftrace","cl"){|x|
  if not(x.is_a?(Loperator))
    x=(eval_function(x,$top_level_environment,true);lisp_value_pop)
  end
  $trace_table[x]=$t
  x.trace=true
  x}

defprimitive("funtrace","cl"){|x|
  if not(x.is_a?(Loperator))
    x=(eval_function(x,$top_level_environment,true);lisp_value_pop)
  end
  $trace_table.delete(x)
  x.trace=nil
  x}

class Larray < Array
  def inspect
    "#(#{result=""
         self.each{|x| result+=x.inspect+" "}
         result[0,result.length-1]})"
  end
end

defprimitive("make-array","cl"){|dimension,initial|
  if initial.nil?
    initial=$lisp_nil
  end
  Larray.new(dimension,initial)}

defprimitive("aref","cl"){|array,index|
  tmp=array[index]
  if tmp
    if array.is_a?(String)
      Lchar.new(tmp)
    else
      tmp
    end
  else
    error "Error -- index #{index.inspect} is out of range of the array.\n"
  end}

defprimitive(".inv-aref","system"){|array,index,value|
  if array[index].nil?
    error "Error -- index #{index.inspect} is out of range of the array.\n"
  end
  array[index]=value
  value}

defprimitive("string-ref","sys"){|x,y|
  Lchar.new(x[y])}

defprimitive("string","cl"){|x|
  if x.is_a?(Lsymbol)
    x.name
  else
    x.to_s
  end}

defprimitive("not","cl"){|x|
  if x == $lisp_nil
    $t
  else
    $lisp_nil
  end}

defprimitive("cons","cl"){|x,y|
  Cons.new(x,y)}

defprimitive("consp","cl"){|x|
  if x.is_a?(Cons)
    $t
  else
    $lisp_nil
  end}

defprimitive("symbolp","cl"){|x|
  if x.is_a?(Lsymbol)
    $t
  else
    $lisp_nil
  end}

defprimitive("constantp","cl"){|x|
  if self_eval_p(x) or (x.is_a?(Lsymbol) and x.vartype == :constant)
    $t
  else
    $lisp_nil
  end}

defprimitive("car","cl"){|x|
  x.car}

defprimitive("cdr","cl"){|x|
  x.cdr}

defprimitive("rplaca","cl"){|x,y|
  x.car = y}

defprimitive("rplacd","cl"){|x,y|
  x.cdr = y}

def lisp_print (x, stream)
  if stream==$lisp_nil
    if x.is_a?(String)
      print "\"#{x}\"\n"
    else
      p x
    end
  else
    if x.is_a?(String)
      stream.write("\"#{x}\"\n")
    else
      stream.write("#{x.inspect}\n")
    end
  end
  x
end

def lisp_princ (x, stream)
  if stream==$lisp_nil
    print x
  else
    if x.is_a?(String)
      stream.write(x)
    else
      stream.write(x.inspect)
    end
  end
  x
end

defprimitive(".print","sys"){|x,stream|
  lisp_print(x,stream)}

defprimitive(".princ","sys"){|x,stream|
  lisp_princ(x,stream)}

defprimitive("exit","cl"){
  print "Bye!\n"
  throw :exit}

# special, constant variable API ;; not ANSI name
defprimitive("set-special","system"){|x|
  x.assume_special
  x}

defprimitive(".inv-defvar","sys"){|x,newvalue|
  if x.value==:unbound
    x.set_symbol_value(newvalue)
  end
  x}

defprimitive("set-constant","system"){|x|
  x.assume_constant
  x}

def apply_helper (arg_array)
  tmp=arg_array.shift
  if arg_array.empty?
    tmp
  else
    Cons.new(tmp,apply_helper(arg_array))
  end
end

Lsymbol.new("apply","cl").function=LPrimitivefunction.new(find_symbol("apply","cl"),lambda{|binding,func,*args|
  apply((if func.is_a?(Lsymbol)
           func.symbol_function
         else
           func
         end),apply_helper(args),binding)})
          
find_symbol("apply","cl").function.need_bind=true

Lsymbol.new("maphash","cl").function=LPrimitivefunction.new(find_symbol("maphash","cl"),lambda{|binding,func,table|
  table.each{|k,v| apply(func,list(k,v),binding)}
  $lisp_value_stack=[$lisp_nil]})

find_symbol("maphash","cl").function.need_bind=true

Lsymbol.new("get-current-environment","system").function=LPrimitivefunction.new(find_symbol("get-current-environment","system"),lambda{|binding|
  $lisp_value_stack = [binding]})
find_symbol("get-current-environment","system").function.need_bind=true

Lsymbol.new("values","cl").function=LPrimitivefunction.new(find_symbol("values","cl"),lambda{|*args| $lisp_value_stack = args})

Lsymbol.new("eval","cl").function=LPrimitivefunction.new(find_symbol("eval","cl"),lambda{|form| lisp_eval(form)})

Lsymbol.new(".intern","sys").function=LPrimitivefunction.new(find_symbol("intern","cl"),lambda{|name,pack| $lisp_value_stack = intern(name,pack,true)})

Lsymbol.new(".find-symbol","sys").function=LPrimitivefunction.new(find_symbol("find-symbol","cl"),lambda{|name,pack|
  tmp=find_symbol_lisp(name,pack,true)
  if tmp
    $lisp_value_stack=tmp
  else
    $lisp_value_stack=[$lisp_nil,$lisp_nil]
  end})

defprimitive(".unintern","sys"){|symbol,pack|
  unintern(symbol,pack)}

def macroexpand_1 (x, binding = $top_level_environment)
  if x.is_a?(Cons) and x.car.is_a?(Lsymbol)
    bind=find_binding(x.car,binding[1])
    fun=(if bind
           bind[1]
         else
           x.car.function
         end)
    if is_macro?(fun)
      apply(fun,list(x,binding),binding)
      lisp_value_pop
    else
      x
    end
  else
    bind=find_binding(x,binding[0])
    if bind and bind[1].is_a?(LSymbolmacro)
      bind[1].body
    else
      x
    end
  end
end

def macroexpand (sexp,binding = $top_level_environment)
  expand=macroexpand_1(sexp,binding)
  if sexp==expand
    expand
  else
    macroexpand(expand,binding)
  end
end

def lisp_load (filename)
  stream=open_file_input(filename)
  begin
    loop{begin
          lisp_eval(read(stream))
         rescue LsimpleError => e
           e.invoke
           raise EOFError.new
         end
      }
  rescue EOFError
    $lisp_nil
  end
end

def read_from_string (string, start = nil, finnish = nil)
  read(make_string_input_stream(string,start,finnish))
end

defprimitive("read-string","cl"){|endchar,stream|
  read_string(endchar.code,stream)}

defprimitive("load","cl"){|x|
  lisp_load x}

defprimitive("open-input-file","sys"){|filespec|
  open_file_input(filespec)}

defprimitive("open-output-file","sys"){|filespec|
  open_file_output(filespec)}

defprimitive("close","cl"){|stream|
  stream.close}

defprimitive("make-string-output-stream","sys"){
  Loutputstream.new}

defprimitive("string-output-stream-body","sys"){|stream|
  stream.string}

defprimitive("error","cl"){|x|
  if x.is_a?(LsimpleError)
    x.invoke
  else
    error "#{x}\n"
  end
  }

def import_primitive (name)
  eval("defprimitive(\"#{name.gsub(/_/,"-")}\",\"cl\"){|*args| #{name}(*args)}")
end

["find_package",
 "make_package",
 "use_package",
 "package_use_list",
 "export",
 "import",
 "list",
 "append",
 "nconc",
 "read",
 "read_from_string",
 "make_string_input_stream",
 "get_macro_character",
 "set_macro_character",
 "make_dispatch_macro_character",
 "set_dispatch_macro_character",
 "read_delimited_list",
 "read_char",
 "macroexpand",
 "macroexpand_1"].each{|x| import_primitive x}