require 'csv'
require 'pathname'

out = []
n = 0

if ( ARGV.length >= 2 ) then
  inputFile = ARGV[0]
  outputFile = ARGV[1]
elsif ( ARGV.length == 1 ) then
  inputFile = ARGV[0]
  outputFile = Pathname(ARGV[0]).sub_ext(".arff").to_s 
else
  inputFile = "mytest.csv"
  outputFile = "mytest.arff"
end


h = "@relation mydata1\n"
for i in 0..63 do 
  h += sprintf("@attribute %02d real\n",i)
end
h += "@attribute class {0,1,2,3,4,5,6,7,8,9}\n"
h += "@data\n"

File.write(outputFile,h)

CSV.open(outputFile, "a") do |csv|
  i = -1
  CSV.foreach(inputFile) do |line|
    line = line.map{ |x| x.to_i } 
    if line.length < 8 then 
      line.push(*Array.new(8-line.length,0)) 
    elsif line.length > 8 then
      line = line[0..7]
    end
    i += 1
    if ( i == 0 ) then n = line[0]; next end
    if ( i == 1 ) then out = line; next end
    out.push(*line)
    if ( i >= 8 ) then 
      csv << out.push(n)
      i = -1 
    end
  end  
  if ( i < 8 && i >= 0 ) then
    (8-i).times{ out.push(*Array.new(8,0)) }
    csv << out.push(n)
  end
end
